ROUND2 equ 10


;  Procedure calculate slices horizontal line ->     --
;   -> buffer, witch describes depth history of each --
;  screen pixel. each pixel 4 float variables <=>    --
;   <=> means 4 depth layers --------------------------
;  When draw_flag = 20 than                          --
;  Proc counts slices of overlapped transparent      --
;  triangles, each  counter as byte, each pixel have --
;  own counter.-------------------- -------------------
;  First triangle calling two loops in file          --
;  3stencil.inc ---------------------------------------

stencil_slices_line:
;------------------------------------------------------
;-------------in xmm0 - lo -> hi z1, z2 ---------------
;--------------- eax - x1 -----------------------------
;--------------- ebx - x2 -----------------------------
;--------------- ecx - y-------------------------------
;--------------- esi - pointer to buff ----------------

.dz     equ  [ebp-4]
.z2     equ  [ebp-8]
.z1     equ  [ebp-12]
.x2     equ  [ebp-16]
.x1     equ  [ebp-20]
.s_buf  equ  [ebp-24]


     push       ebp
     mov        ebp,esp
     sub        esp,64
     or         cx,cx
     jle        .l_quit
     cmp        cx,[yres_var]
     jge        .l_quit
     movzx      ecx,cx
     mov        .s_buf,esi
     cmp        eax,ebx
     je         .l_quit
     jl         .l_ok
     xchg       eax,ebx
     shufps     xmm0,xmm0,11100001b
   .l_ok:
     cmp        ax,[xres_var]
     jge        .l_quit
     cmp        bx,0
     jle        .l_quit
     movlps     .z1,xmm0
     mov        .x1,eax
     mov        .x2,ebx
     sub        ebx,eax
     movss      xmm0,.z2
     cvtsi2ss   xmm1,ebx
     subss      xmm0,.z1
     divss      xmm0,xmm1
     movss      .dz,xmm0
     movzx      edx,word[xres_var]
     cmp        eax,1
     jge        @f
     mov        eax,.x1
     neg        eax
     cvtsi2ss   xmm2,eax
     mulss      xmm2,.dz
     addss      xmm2,.z1
     movss      .z1,xmm2
     mov        dword .x1,0
     movzx      edx,word[xres_var]
     sub        edx,1
   @@:
     cmp        .x2,edx
     jl         @f
     mov        .x2,edx
   @@:
     movzx      edx,word[xres_var]
     mov        edi,.s_buf
     mov        eax,ecx  ; y
     mul        edx
     mov        edx,ecx  ; edx = y
     add        eax,.x1
     mov        ecx,.x2
     sub        ecx,.x1
     cmp        [draw_flag],20
     je         .count
     shl        eax,4
     add        edi,eax
     movss      xmm2,.z1   ; cz
   .ccalc:
     shufps    xmm2,xmm2,0
     movaps    xmm1,xmm2
     movups    xmm3,[edi]
     cmpltps   xmm1,xmm3
     pmovmskb  eax,xmm1
     cmp       eax,0xffff
     jnz       @f
     shufps    xmm3,xmm3,10010000b
     movups    [edi],xmm3
     movss     [edi],xmm2
     jmp       .update_counters
  @@:
     cmp        eax,0xfff0
     jnz        @f
     shufps     xmm3,xmm3,10010000b
     movups     [edi],xmm3
     movss      [edi+4],xmm2
     jmp        .update_counters
  @@:
     cmp        eax,0xff00
     jnz        @f
     shufps     xmm3,xmm3,10000100b
     movups     [edi],xmm3
     movss      [edi+8],xmm2
     jmp        .update_counters
  @@:
     cmp        eax,0xf000
     jnz        @f
     movss      [edi+12],xmm2
  @@:
 .update_counters:
     add       edi,16
     addss     xmm2,.dz
     loop       .ccalc
  .l_quit:
     mov       esp,ebp
     pop       ebp
ret

  .count:
     add       edi,eax
     movaps    xmm2,[sli_cnt_const]
     shr       ecx,1
     jnc       @f
     movlps    xmm0,[edi]
     paddusb   xmm0,xmm2
     movd      eax,xmm0
     mov       [edi],al
     inc       edi
     jecxz     .scl_l_quit
   @@:
     movlps    xmm0,[edi]
     paddusb   xmm0,xmm2
     movd      eax,xmm0
     mov       [edi],ax
     add       edi,2
     loop      @b
  .scl_l_quit:
     mov       esp,ebp
     pop       ebp
ret
